% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Coefficient}
\alias{CT_Coefficient}
\title{Concordance Coefficient and Kruskal-Wallis Statistic}
\usage{
CT_Coefficient(Sample_List, H = 0)
}
\arguments{
\item{Sample_List}{List of numeric data vectors with the elements of each sample.}

\item{H}{0 by default. If set to 1, the Kruskal-Wallis statistic is also calculated and returned.}
}
\value{
The function returns a list with the following elements:
\enumerate{
\item{ \code{Sample_Sizes}: Numeric vector of sample sizes.}
 \item{ \code{order_elements}: Numeric vector containing the elements order. }
\item{ \code{disorder}: Disorder of the permutation given by \code{order_elements}.}
 \item{ \code{Concordance_Coefficient}: 1-relative disorder of permutation given by \code{order_elements}. }
 \item{ \code{H_Statistic}: Kruskal-Wallis statistic (only if H = 1). }
}
}
\description{
This function computes the Concordance coefficient and the Kruskal-Wallis statistic.
}
\examples{
## Example
A <- c(12,13,15,20,23,28,30,32,40,48)
B <- c(29,31,49,52,54)
C <- c(24,26,44)
Sample_List <- list(A, B, C)
CT_Coefficient(Sample_List)
CT_Coefficient(Sample_List, H = 1)

## Example with ties
A <- c(12,13,15,20,24,29,30,32,40,49)
B <- c(29,31,49,52,54)
C <- c(24,26,44)
Sample_List <- list(A, B, C)
CT_Coefficient(Sample_List, H = 1)
}
