% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bCond.simpA.CKT.R
\name{bCond.simpA.CKT}
\alias{bCond.simpA.CKT}
\title{Function for testing the simplifying assumption with
data-driven box-type conditioning events}
\usage{
bCond.simpA.CKT(
  XI,
  XJ = NULL,
  matrixInd = NULL,
  minCut = 0,
  minProb = 0.01,
  minSize = minProb * nrow(XI),
  nPoints_xJ = 10,
  type.quantile = 7,
  verbose = 2,
  methodTree = "doSplit",
  propTree = 0.5,
  methodPvalue = "bootNP",
  nBootstrap = 100
)
}
\arguments{
\item{XI}{matrix of size n*p of observations of the conditioned variables.}

\item{XJ}{matrix of size n*(d-p) containing observations of the conditioning vector.}

\item{matrixInd}{a matrix of indexes of size (n, N.boxes) describing
for each observation i to which box ( = event) it belongs.

If it is \code{NULL}, then a tree will be estimated to provide relevant boxes
(by using \code{\link{bCond.treeCKT}()})
and then converting to a \code{matrixInd} by \code{\link{treeCKT2matrixInd}()}.}

\item{minCut}{minimum difference in probabilities that is necessary to cut.}

\item{minProb}{minimum probability of being in one of the node.}

\item{minSize}{minimum number of observations in each node.
This is an alternative to minProb and has priority over it.}

\item{nPoints_xJ}{number of points in the grid that are considered
when choosing the point for splitting the tree.}

\item{type.quantile}{way of computing the quantiles,
see \code{stats::\link[stats]{quantile}()}.}

\item{verbose}{control the text output of the procedure.
If \code{verbose = 0}, suppress all output.
If \code{verbose = 2}, the progress of the computation
is printed during the computation.}

\item{methodTree}{method for constructing the tree
\itemize{
\item \code{doSplit} some part of the data is used for constructing the tree
  and the other part for constructing the test statistic
  using the boxes defined by the estimated tree.
  The share of the data used for construction the tree is controlled by
  the parameter \code{propTree}.
\item \code{noSplit} all of the data is used for
  both the tree and the test statistic on it.
  Note that p-values obtained by this method have an upward bias
  due to the lack of independence between these two steps.
}
Only used if \code{matrixInd} is not provided.}

\item{propTree}{share of observations used to build the tree
(the rest of the observations are used for the computation of the p-value).
Only used if \code{matrixInd} is not provided.}

\item{methodPvalue}{method for computing the p-value \itemize{
\item \code{covMatrix} by computation of the covariance matrix of
  the random vector \eqn{(\tau_{i,k|X_J \in A_j}, 1\leq,i,k\leq p, 1\leq j \leq m)}.
\item \code{bootNP} by the usual non-parametric bootstrap
\item \code{bootInd} by the independent bootstrap
}}

\item{nBootstrap}{number of bootstrap replications
(Only used if \code{methodPvalue} is not \code{covMatrix}).}
}
\value{
a list with the following components \itemize{
\item \code{p.value} the estimated p-value.
\item \code{stat} the test statistic.
\item \code{treeCKT} the estimated tree if \code{matrixInd} is not provided.
\item \code{vec_statB} the vector of bootstrapped statistics
if \code{methodPvalue} is not \code{covMatrix}.
}
}
\description{
This function takes in parameter the matrix of (observations) of the
conditioned variables and either \code{matrixInd}, a matrix of indicator variables
describing which events occur for which observations
}
\references{
Derumigny, A., Fermanian, J. D., & Min, A. (2020).
Testing for equality between conditional copulas
given discretized conditioning events.
ArXiv preprint \href{https://arxiv.org/abs/2008.09498}{arxiv:2008.09498}.
}
\seealso{
\code{\link{bCond.simpA.param}} for a test of this simplifying assumption
in a parametric framework.

\code{\link{bCond.treeCKT}} provides the binary tree that is used in this function
(if \code{matrixInd} is not provided).

Tests of the simplifying assumption for conditional copulas with a continuous
conditioning variable:
\itemize{
  \item \code{\link{simpA.NP}} in a nonparametric setting
  \item \code{\link{simpA.param}} in a (semi)parametric setting,
  where the conditional copula belongs to a parametric family,
  but the conditional margins are estimated arbitrarily through
  kernel smoothing
  \item \code{\link{simpA.kendallReg}}: test based on the constancy of
  conditional Kendall's tau
}
}
\author{
Alexis Derumigny, Jean-David Fermanian and Aleksey Min
}
