% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatrix.R
\name{correlatrix}
\alias{correlatrix}
\title{Correlatrix}
\usage{
correlatrix(data, var.names, round = 3, method = "pearson", n.matrix = F,
  name.max = 100)
}
\arguments{
\item{data}{an object of class 'data.frame' or 'imputationList'}

\item{var.names}{a vector of collumn names}

\item{round}{a numeral indicating number of decimals}

\item{method}{a string containing one of "pearson","spearman" or "kendall"}

\item{n.matrix}{logical. If TRUE, matrix of n returned}

\item{name.max}{a number indicating the maximum length of variable names}
}
\value{
A correlation matrix
}
\description{
Takes in a data.frame or imputationList, a vector of collumn names and produces a correlation matrix
}
\examples{
carsdata<-mtcars
correlatrix(carsdata,names(carsdata),round = 2)
correlatrix(carsdata,c("mpg","cyl","disp"))
}

