% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigs.R
\name{eigs}
\alias{eigs}
\title{Compute some eigenvalues of a matrix}
\usage{
eigs(M, nev = min(dim(M)[1] - 1, 1), sym = sum(abs(M - t(M)))/sum(abs(M)) <
  1e-10, which = "LM", use.arpack = TRUE, options.arpack = NULL)
}
\arguments{
\item{M}{a matrix.}

\item{nev}{number of eigenvalues and eigenvectors to return}

\item{sym}{A boolean indicating if matrix is symmetric or not.  Defaults to 
checking if this is the case or not.}

\item{which}{A character string indicating which eigenvalues to return. 
Defaults to "LM", meaning largest magnitude eigenvalues. If not using 
\code{\link[igraph]{arpack}}, then "SM" is also a possibility to return the
smallest magnitude eigenvalues. If using \code{\link[igraph]{arpack}}, then
a number of options are possible, though they are not all guaranteed to 
work for all use cases. See that function for more details.}

\item{use.arpack}{Boolean determining if calculation is to be done with 
\code{\link[igraph]{arpack}} function from the \link[igraph]{igraph} 
package. This is much quicker for large matrices, but requires 
\link[igraph]{igraph}. Defaults to TRUE, but will use eigen instead if 
\link[igraph]{igraph} is not found.}

\item{options.arpack}{Additional options for \code{\link[igraph]{arpack}}. 
See that function for details.  Not all options are compatible with this 
function.}
}
\value{
A list with at least the following two items:
  
  \item{values}{A set of eigenvalues}
  
  \item{vectors}{A matrix of eigenvectors}
}
\description{
This function computes a limited number of eigenvalues and eigenvectors of a 
matrix. It uses \code{\link[igraph]{arpack}} function from the 
\link[igraph]{igraph} package. If this package is not available, it will use 
the standard \code{\link{eigen}} function to do the calculation, but will 
issue a warning.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\seealso{
See also \code{\link[igraph]{arpack}}
}

