% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinpmatr.R
\name{combinpmatr}
\alias{combinpmatr}
\title{Combined input matrix of a data set}
\usage{
combinpmatr(X, Wk = NULL)
}
\arguments{
\item{X}{A data matrix N by M, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}
}
\value{
The M by M combined input matrix
}
\description{
Compute the Combined input matrix of a data set as defined by Emond and Mason (2002)
}
\examples{
data(APAred) 
CI<-combinpmatr(APAred) 
TR<-tabulaterows(APAred) 
CI<-combinpmatr(TR$X,TR$Wk)

}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28.
}
\seealso{
\code{\link{tabulaterows}} frequency distribution of a ranking data.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
