% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BankruptcyGame.R
\name{bankruptcyGame}
\alias{bankruptcyGame}
\title{Construct a bankruptcy game}
\usage{
bankruptcyGame(n, d, E)
}
\arguments{
\item{n}{represents the number of players}

\item{d}{numeric vector which contains the claims of each player in a bankruptcy game}

\item{E}{is the value of the estate in a bankruptcy game}
}
\value{
A list with four elements 
representing the specified bankruptcy 
game (n, d, E, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified bankruptcy game:}\cr
The list contains the number of players, 
the claims vector, the estate and the bankruptcy game vector. 
Bankruptcy games are defined by a vector of debts \code{d}
of \code{n} creditors (players) and an estate \code{E} less 
than the sum of the debt vector. The roots of bankruptcy 
games can be traced back to the Babylonian Talmud.
}
\section{Related Functions}{
 
\link{bankruptcyGameValue}, \link{bankruptcyGameVector}
}

\examples{
library(CoopGame)
bankruptcyGame(n=3, d=c(1,2,3), E=4)

\donttest{
#Estate division problem from Babylonian Talmud 
#from paper by Aumann (2002) with E=300
library(CoopGame)
bankruptcyGame(n=3,d=c(100,200,300),E=300)
#Output
#$n
#[1] 3

#$d
#[1] 100 200 300

#$E
#[1] 300

#$v
#[1]   0   0   0   0 100 200 300
}

}
\references{
O'Neill, B. (1982) "A problem of rights arbitration from the Talmud", Mathematical Social Sciences 4(2), pp. 345 -- 371

Aumann R.J. and Maschler M. (1985) "Game Theoretic Analysis of a Bankruptcy Problem from the Talmud", Journal of Economic Theory 36(1), pp. 195 -- 213

Aumann R.J. (2002) "Game Theory in the Talmud", Research Bulletin Series on Jewish Law and Economics, 12 pages.

Gura E. and Maschler M. (2008) \emph{Insights into Game Theory}, Cambridge University Press, pp. 166--204
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
