% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BankruptcyGame.R
\name{bankruptcyGameValue}
\alias{bankruptcyGameValue}
\title{Compute value of a coalition for a bankruptcy game}
\usage{
bankruptcyGameValue(S, d, E)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{d}{numeric vector which contains the claims of each player in a bankruptcy game}

\item{E}{is the value of the estate in a bankruptcy game}
}
\value{
A positive value if the sum of the claims outside of coalition \code{S} is less than \code{E}
else \code{0}
}
\description{
\strong{Coalition value for a specified bankruptcy game:} \cr
For further information see \link{bankruptcyGame}
}
\examples{
library(CoopGame)
bankruptcyGameValue(S=c(2,3),d=c(1,2,3),E=4)

\donttest{
#Estate division problem from Babylonian Talmud 
#from paper by Aumann (2002) with E=300
library(CoopGame)
bankruptcyGameValue(S=c(2,3),d=c(100,200,300),E=300)
#Output
#[1] 200
}

}
\references{
O'Neill, B. (1982) "A problem of rights arbitration from the Talmud", Mathematical Social Sciences 4(2), pp. 345 -- 371

Aumann R.J. and Maschler M. (1985) "Game Theoretic Analysis of a Bankruptcy Problem from the Talmud", Journal of Economic Theory 36(1), pp. 195 -- 213

Aumann R.J. (2002) "Game Theory in the Talmud", Research Bulletin Series on Jewish Law and Economics, 12 pages.

Gura E. and Maschler M. (2008) \emph{Insights into Game Theory}, Cambridge University Press, pp. 166--204
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
