% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KoenigBraeuningerConcept.R
\name{koenigBraeuningerIndex}
\alias{koenigBraeuningerIndex}
\title{Compute Koenig-Braeuninger index}
\usage{
koenigBraeuningerIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Koenig-Braeuninger index for specified simple game
}
\description{
Calculates the Koenig-Braeuninger index for a specified simple TU game.
Note that in general the Koenig-Braeuninger index is not an efficient vector, 
i.e. the sum of its entries is not always 1. 
Hence no drawing routine for the Koenig-Braeuninger index is provided.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
koenigBraeuningerIndex(v) 

}
\references{
Koenig T. and Braeuninger T. (1998) "The inclusiveness of European decision rules", Journal of Theoretical Politics 10(1), pp. 125--142

Nevison C.H., Zicht, B. and Schoepke S. (1978) "A naive approach to the Banzhaf index of power", Behavioral Science 23(2), pp. 130--131

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
