% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_gbif.R
\name{cc_gbif}
\alias{cc_gbif}
\title{Identify Records Assigned to GBIF Headquarters}
\usage{
cc_gbif(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  species = "species",
  buffer = 1000,
  geod = TRUE,
  verify = FALSE,
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species
names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimallongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimallatitude}.}

\item{species}{character string. The column with the species identity. Only
required if verify = TRUE.}

\item{buffer}{numerical. The buffer around the GBIF headquarters,
where records should be flagged as problematic. Units depend on geod. Default = 100 m.}

\item{geod}{logical. If TRUE the radius is calculated
based on a sphere, buffer is in meters. If FALSE
the radius is calculated in degrees. Default = T.}

\item{verify}{logical. If TRUE records are only flagged if they are the
only record in a given species flagged close to a given reference.
If FALSE, the distance is the only criterion}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
containing the records considered correct by the test (\dQuote{clean}) or a
logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test failed/potentially
problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records within 0.5 degree radius around the GBIF headquarters in
Copenhagen, DK.
}
\details{
Not recommended if working with records from Denmark or the Copenhagen area.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner} for more
details and tutorials.
}
\examples{

x <- data.frame(species = "A", 
                decimallongitude = c(12.58, 12.58), 
                decimallatitude = c(55.67, 30.00))
                
cc_gbif(x)
cc_gbif(x, value = "flagged")

}
\seealso{
Other Coordinates: 
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_urb}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
