% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_range.R
\name{cf_range}
\alias{cf_range}
\title{Identify Fossils with Extreme Age Ranges}
\usage{
cf_range(
  x,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  min_age = "min_ma",
  max_age = "max_ma",
  taxon = "accepted_name",
  method = "quantile",
  mltpl = 5,
  size_thresh = 7,
  max_range = 500,
  uniq_loc = FALSE,
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing fossil records with taxon names, ages, 
and geographic coordinates.}

\item{lon}{character string. The column with the longitude coordinates.
To identify unique records if \code{uniq_loc  = TRUE}.
Default = \dQuote{decimalLongitude}.}

\item{lat}{character string. The column with the longitude coordinates.
Default = \dQuote{decimalLatitude}. To identify unique records if \code{uniq_loc  = T}.}

\item{min_age}{character string. The column with the minimum age. Default
= \dQuote{min_ma}.}

\item{max_age}{character string. The column with the maximum age. Default
= \dQuote{max_ma}.}

\item{taxon}{character string. The column with the taxon name. If
\dQuote{}, searches for outliers over the entire dataset, otherwise per
specified taxon. Default = \dQuote{accepted_name}.}

\item{method}{character string.  Defining the method for outlier
selection.  See details. Either \dQuote{quantile} or \dQuote{mad}.  Default
= \dQuote{quantile}.}

\item{mltpl}{numeric. The multiplier of the interquartile range
(\code{method == 'quantile'}) or median absolute deviation (\code{method ==
'mad'}) to identify outliers. See details.  Default = 5.}

\item{size_thresh}{numeric.  The minimum number of records needed for a
dataset to be tested. Default = 10.}

\item{max_range}{numeric. A absolute maximum time interval between min age
and max age. Only relevant for \code{method} = \dQuote{time}.}

\item{uniq_loc}{logical.  If TRUE only single records per location and time
point (and taxon if \code{taxon} != "") are used for the outlier testing.
Default = T.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records with an unexpectedly large temporal range, based on a quantile
outlier test.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{

minages <- runif(n = 11, min = 0.1, max = 25)
x <- data.frame(species = c(letters[1:10], "z"),
                lng = c(runif(n = 9, min = 4, max = 16), 75, 7),
                lat = c(runif(n = 11, min = -5, max = 5)),
                min_ma = minages, 
                max_ma = minages + c(runif(n = 10, min = 0, max = 5), 25))

cf_range(x, value = "flagged", taxon = "")

}
\seealso{
Other fossils: 
\code{\link{cf_age}()},
\code{\link{cf_equal}()},
\code{\link{cf_outl}()},
\code{\link{write_pyrate}()}
}
\concept{fossils}
\keyword{Fossil}
\keyword{Temporal}
\keyword{cleaning}
