% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimGenCluster.R
\name{SimGenCluster}
\alias{SimGenCluster}
\title{Simulation of clustered data}
\usage{
SimGenCluster(
  parC,
  parM,
  clu,
  xc = NULL,
  xm = NULL,
  family,
  rot = 0,
  dfC = NULL,
  model,
  dfM = NULL,
  offset = NULL
)
}
\arguments{
\item{parC}{vector of copula parameters; k1  is the number of covariates + constant for the copula}

\item{parM}{vector of margin parameters; k2  is the number of covariates + constant for the margins}

\item{clu}{vector of clusters (can be a factor)}

\item{xc}{matrix (N x k1) of covariates for the copula, not including the constant (can be NULL)}

\item{xm}{matrix (N x k2) of covariates for the margins, not including the constant (can be NULL)}

\item{family}{copula family: "gaussian" , "t" , "clayton" ,  "joe", "frank" , "gumbel", "plackett"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{dfC}{degrees of freedom for the Student copula (default is NULL)}

\item{model}{marginal distribution: "binomial" (bernoulli), "poisson", "nbinom" (mean is the parameter),"nbinom1" (p is the parameter), "geometric", "multinomial", exponential", "weibull", "normal" (gaussian),"t", "laplace"}

\item{dfM}{degrees of freedom for the Student margins (default is NULL)}

\item{offset}{offset for the margins (default is NULL)}
}
\value{
\item{y}{Simulated response}

\item{y}{Simulated values}
}
\description{
Generate a random sample of observations from a copula-based mixed regression model.
}
\examples{
K=50 #number of clusters
n=5  #size of each cluster
N=n*K
set.seed(1)
clu=rep(c(1:K),each=n)
parC = 2
parM= c(1,-1,4)
xm = runif(N)
y=SimGenCluster(parC,parM,xm,family="clayton",rot=90,clu=clu,model="gaussian")
}
\author{
Bruno N. Remillard
}
