% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAP.discrete.R
\name{MAP.discrete}
\alias{MAP.discrete}
\title{Estimation of latent variable in the dicrete case}
\usage{
MAP.discrete(vv, uu, family, rot, thC0k, dfC = NULL, adj = 1, nq = 35)
}
\arguments{
\item{vv}{vector of values in (0,1)}

\item{uu}{vector of values in (0,1)}

\item{family}{copula family "gaussian" , "t" , "clayton" ,  "joe", "frank" , "fgm", gumbel", "plackett", "galambos", "huesler-reiss"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270.}

\item{thC0k}{vector of copula parameters}

\item{dfC}{degrees of freedom for the Student copula (default is NULL)}

\item{adj}{tuning parameter (>= 1) that can be used to prevent overflow when the cluster size n is very large; when  n<=100 OR Bernoulli marginals, no adjustment is required; when n>=500 for the Poisson likelihood fails due to overflow problem;  adj=3 prevents this in 100\% cases}

\item{nq}{number of nodes and weighted for Gaussian quadrature of the product of conditional copulas; default is 31.}
}
\value{
\item{condmed}{Conditional a posteriori median.}
}
\description{
This function computes the estimation of a latent variables foe=r each cluster using the conditional a posteriori median.
}
\examples{
uu = c(0.5228155, 0.3064417, 0.2789849, 0.5176489, 0.3587144)
vv = c(0.7816627, 0.6688788, 0.6351364, 0.7774917, 0.7264787)
thC0k=rep(17.54873,5)
MAP.discrete(vv,uu,"clayton",rot=90,thC0k,nq=35)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii, Bouchra R. Nasri and Bruno N. Remillard
}
