% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCorShrinkData2.R
\name{pCorShrinkData2}
\alias{pCorShrinkData2}
\title{Adaptive shrinkage of a partial correlation matrix}
\usage{
pCorShrinkData2(data, type = c("no_bag", "bag_cor", "bag_pcor"), nbags = 10,
  nboot = 50, thresh_up = 0.99, thresh_down = -0.99, tol = 1e-06,
  report_model = FALSE, ash.control = list())
}
\arguments{
\item{data}{The samples by features data matrix. May contain NA values.}

\item{type}{The type of bagging method used, if at all, for estimating the
partial corelation matrix. The three possible types are -
\code{no_bag}, \code{bag_cor} and \code{bag_pcor} - indicating
if bagging is at all used, or if is performed at the level of
correlations before taking partial correlation matroix on the
bagged correlation values, or at the level of partial correlations
directly.}

\item{nbags}{If \code{type} not equal to \code{no_bag}, how many bootstrap
samples are generated to get the bagging estimate.}

\item{nboot}{The number of bootstrap samples used to compute the bootstrap
standard errors of the partial correlations used for shrinking
in \code{CorShrink}.}

\item{thresh_up}{Upper threshold for correlations in \code{cormat}. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations in \code{cormat}. Defaults to -0.99}

\item{tol}{The tolerance chosen to check how far apart the CorShrink matrix is from the nearest
positive definite matrix before applying PD completion.}

\item{report_model}{if TRUE, outputs the full adaptive shrinkage output, else outputs the shrunken vector.
Defaults to FALSE.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
If \code{report_model = FALSE}, returns the adaptively shrunk
        partial correlation matrix. If \code{report_model = TRUE}, then the
        function also returns all the details of the adaptive shrinkage model
        output.
}
\description{
This function performs adaptive shrinkage of a matrix of
partial correlations using a similar model as \code{CorShrinkMatrix}, but
with the option of being aided by bagging on the data matrix.
}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216;
             doi: http://dx.doi.org/10.1101/038216
}
\keyword{adaptive}
\keyword{correlation}
\keyword{shrinkage,}
