% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_simulation.R
\name{simulate_dropout}
\alias{simulate_dropout}
\title{Simulate dropout expression data}
\usage{
simulate_dropout(counts, dropout.rate = 0, dropout.rate.sd = 0.1)
}
\arguments{
\item{counts}{expression matrix where each row is a gene and each column is a sample.}

\item{dropout.rate}{the desired average dropout rate of all samples.}

\item{dropout.rate.sd}{the desired standard deviation of dropout rate among samples.}
}
\value{
This function will return an expression matrix with the same dimension as \code{counts}.
}
\description{
Generate the expression data with desired dropout rate
}
\details{
The dropout event is modelled by a logistic distribution such that the low expression genes have 
higher probability of dropout. The expression value of genes in a sample are randomly set to zero
with probabilities associated with their true expression values until the desired dropout rate
for that sample is meet.
}
\references{
Peter V. Kharchenko, Lev Silberstein, and David T. Scadden.
Bayesian approach to single-cell differential expression analysis.
Nature Methods, 11(7):740–742, 2014.
}
