% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreSetClass.R
\name{CoreSet}
\alias{CoreSet}
\title{CoreSet constructor}
\usage{
CoreSet(name, molecularProfiles = list(), cell = data.frame(),
  sensitivityInfo = data.frame(), sensitivityRaw = array(dim = c(0, 0,
  0)), sensitivityProfiles = matrix(), sensitivityN = matrix(nrow = 0,
  ncol = 0), perturbationN = array(NA, dim = c(0, 0, 0)),
  curationCell = data.frame(), curationTissue = data.frame(),
  datasetType = c("sensitivity", "perturbation", "both"),
  verify = TRUE)
}
\arguments{
\item{name}{A \code{character} string detailing the name of the dataset}

\item{molecularProfiles}{A \code{list} of ExpressionSet objects containing
molecular profiles}

\item{cell}{A \code{data.frame} containg the annotations for all the cell
lines profiled in the data set, across all data types}

\item{sensitivityInfo}{A \code{data.frame} containing the information for the
sensitivity experiments}

\item{sensitivityRaw}{A 3 Dimensional \code{array} contaning the raw drug
dose response data for the sensitivity experiments}

\item{sensitivityProfiles}{\code{data.frame} containing drug sensitivity profile 
statistics such as IC50 and AUC}

\item{sensitivityN, perturbationN}{A \code{data.frame} summarizing the
available sensitivity/perturbation data}

\item{curationCell, curationTissue}{A \code{data.frame} mapping
the names for cells and tissues used in the data set to universal
identifiers used between different CoreSet objects}

\item{datasetType}{A \code{character} string of 'sensitivity',
'preturbation', or both detailing what type of data can be found in the
CoreSet, for proper processing of the data}

\item{verify}{\code{boolean} Should the function verify the CoreSet and
print out any errors it finds after construction?}
}
\value{
An object of class CoreSet
}
\description{
A constructor that simplifies the process of creating CoreSets, as well 
as creates empty objects for data not provided to the constructor. Only
objects returned by this constructor are expected to work with the CoreSet
methods. For a much more detailed instruction on creating CoreSets, please
see the "CreatingCoreSet" vignette.
}
\examples{
 
## For help creating a CoreSet object, please see the following vignette:
browseVignettes("PharmacoGx")

}
