% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redirectDataset.R
\name{redirectDataset}
\alias{redirectDataset}
\title{Redirect Dataset}
\usage{
redirectDataset(
  dataset = cs.in.dataset(),
  preds = cs.in.predictors(),
  resps = cs.in.responses(),
  groups = cs.in.groupvars(),
  auxs = cs.in.auxiliaries(),
  scriptvars = cs.in.scriptvars(),
  return.results = FALSE
)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictor variables.}

\item{resps}{[\code{character}]\cr
Character vector of response variables.}

\item{groups}{[\code{character}]\cr
Character vector of group variables.}

\item{auxs}{[\code{character}]\cr
Character vector of auxiliary variables.}

\item{scriptvars}{[\code{list}]\cr
Named list of script variables set via the Cornerstone "Script Variables" menu.
For details see below.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}
}
\value{
Logical [\code{TRUE}] invisibly and outputs to Cornerstone \code{cs.out.Robject} or,
  if \code{return.results = TRUE}, \code{\link{list}} of resulting 
  \code{\link{data.frame}} objects and \code{character(n)} vectors:
  \item{dataset}{Input dataset.}
  \item{predictors}{Vector of predictors.}
  \item{responses}{Vector of responses.}
  \item{groups}{Vector of groups.}
  \item{auxiliaries}{Vector of auxiliaries.}
  The \code{list} is wrapped in an additional \code{list} to get the same return value
  corresponding to \code{cs.in.Robject}.
}
\description{
Redirect input dataset to an output R object.
}
\details{
The following script variables are summarized in \code{scriptvars} list:\cr
  \describe{
    \item{remove.pattern}{[\code{character(1)}]\cr
      The given pattern is removed in all variable names via \code{\link{gsub}}.
      Leading and / or trailing whitespaces are removed using \code{\link{trimws}}.
      Default is \code{""}.}
  }
}
