% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plotDiagPhotoZ}
\alias{plotDiagPhotoZ}
\title{Plot diagnostics for photometric redshift  estimations}
\usage{
plotDiagPhotoZ(photoz, specz, type, npoints)
}
\arguments{
\item{photoz}{vector containing photoz data}

\item{specz}{vector containing spectroscopic redshift data}

\item{type}{a string with one of the following values: \code{errordist}, \code{predobs}, \code{errorviolins} or \code{box}}

\item{npoints}{an integer indicating how many points should be used to create the \code{predobs} plot (if 0, all points will be used)}
}
\value{
ggplot object
}
\description{
\code{plotDiagPhotoZ} returns diagnostic plots from the results of
photometric redshifts. Different types of plots are available: a density plot of the
error distribution (\code{errordist}), a predicted versus observed contour plot
(\code{predobs}), violin plot showing the error distribution at different redshift
bins (\code{errorviolins}) and a box plot showing the errors at each different
redshift bin (\code{box}). The produced plots are returned as ggplot2 objects.
}
\examples{
# First, generate some mock data
ppo <- runif(1000, min=0.1, max=2)
ppo_ph <- rnorm(length(ppo), mean=ppo, sd=0.05)

# Then generate the plots
plotDiagPhotoZ(ppo_ph, ppo, type="errordist")
#plotDiagPhotoZ(ppo_ph, ppo, type="predobs")
#plotDiagPhotoZ(ppo_ph, ppo, type="errorviolins")
#plotDiagPhotoZ(ppo_ph, ppo, type="box")
}
\author{
Rafael S. de Souza, Alberto Krone-Martins
}
\keyword{hplot}

