% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_counternull_distribution_no_hist.R
\name{create_counternull_distribution_no_hist}
\alias{create_counternull_distribution_no_hist}
\title{Creates counternull distribution (No Histogram)}
\usage{
create_counternull_distribution_no_hist(
  sample_data,
  rand_matrix,
  permutation_counter_function,
  counternull_value,
  test_stat,
  variable,
  iterations,
  pairs
)
}
\arguments{
\item{sample_data}{Sample data set. Data should have column indicating
exposure (1) or non exposure (0) for each group (row) that is measured. Each
measured outcome (variable) should be represented by an additional column.}

\item{rand_matrix}{Matrix with all possible randomizations of exposure
assignment}

\item{permutation_counter_function}{Function used to create permutation vector
for counternull distribution}

\item{counternull_value}{Number to test out as counternull value}

\item{test_stat}{Observed test statistic.}

\item{variable}{Variable measured.
Format: sample_data$column}

\item{iterations}{Numbers of unique arrangements of exposure assignments
used to generate distribution (At most the number of rows in rand_matrix)}

\item{pairs}{Number of pairs of units there are to measure in dataset
(One pair=control unit + experimental unit)}
}
\value{
Counternull distribution data (Vector)
}
\description{
Resamples data to create counternull distribution.
Returns vector with counternull distribution data points (test statistics
created from resampling).
}
\keyword{internal}
