% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dBivariateWeibull.R
\name{dBivariateWeibullCountFrankCopula}
\alias{dBivariateWeibullCountFrankCopula}
\alias{dBivariateWeibullCountFrankCopula_loglik}
\title{Density and log-likelihood of the Bivariate Frank Copula Weibull Count model}
\usage{
dBivariateWeibullCountFrankCopula(x, y, shapeX, scaleX, shapeY, scaleY, theta,
  method = c("series_acc", "conv_dePril"), time = 1, log = FALSE,
  conv_steps = 100, conv_extrap = TRUE, series_terms = 50,
  series_acc_niter = 300, series_acc_eps = 1e-10)

dBivariateWeibullCountFrankCopula_loglik(x, y, shapeX, scaleX, shapeY, scaleY,
  theta, method = c("series_acc", "conv_dePril"), time = 1, na.rm = TRUE,
  conv_steps = 100, conv_extrap = TRUE, series_terms = 50,
  series_acc_niter = 300, series_acc_eps = 1e-10, weights = NULL)
}
\arguments{
\item{x, y}{numeric, the desired counts.}

\item{shapeX, shapeY}{numeric, shape parameters. Either length(x) or
length(1).}

\item{scaleX, scaleY}{numeric, scale parameters (length(x)).}

\item{theta}{numeric, Frank copula parameter.}

\item{method}{character method to be used. Choices are \code{"series_acc"}
(accelerated series expansion) or \code{"conv_dePril"} (convolution by
dePril algorithm).}

\item{time}{numeric, length of the observation window (defaults to 1).}

\item{log}{TODO}

\item{conv_steps}{integer, number of steps to use in the computation of the
integral.}

\item{conv_extrap}{logical, if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{series_terms}{number of terms used in series expansion}

\item{series_acc_niter}{number of iterations in the acceleration algorithm.}

\item{series_acc_eps}{double, tolerance to declare convergence in the
acceleration algorithm.}

\item{na.rm}{logical, should \code{NA}s (obtained from log of small
probabilities) be replaced with the smallest allowed probability?}

\item{weights}{numeric vector of weights to apply. If \code{NULL}, a vector
of ones.}
}
\value{
for \code{dBivariateWeibullCountFrankCopula}, a vector of the
    (log-)probabilities

for \code{dBivariateWeibullCountFrankCopula_loglik}, the
    log-likelihood of the model, a number
}
\description{
Compute density and log-likelihood of the Bivariate Frank Copula Weibull
Count model.

% Log-likelihood of the Bivariate Frank Copula Weibull Count model
}
\details{
\code{dBivariateWeibullCountFrankCopula} computes the probabilities
\eqn{P(X(t) = x(t), Y(t) = y(t))}, where \eqn{X(t),Y(t)} is a bivariate
Weibull count process in which the bivariate distribution is modelled by
Frank copulas.
}
\examples{
## first 10 cases from "estimationParams.RDS", rounded for presentation
gam_weiH <-  0.9530455
gam_weiA <-  1.010051
theta    <- -0.3703702
HG <- c(0, 0, 0, 2, 1, 0, 2, 0, 1, 2)
AG <- c(2, 2, 1, 1, 6, 1, 0, 2, 0, 1)
lambdaHome <- c(1.5, 1.0, 1.3, 1.8, 1.3, 1.2, 1.3, 1.0, 2.0, 1.4)
lambdaAway <- c(1.2, 2.4, 1.3, 0.7, 1.3, 1.4, 0.6, 1.6, 0.6, 1.3)

weiFrank0 <- dBivariateWeibullCountFrankCopula(
    HG, AG, gam_weiH, lambdaHome, gam_weiA, lambdaAway, theta,
    "series_acc", 1, TRUE)

weiFrank1 <- dBivariateWeibullCountFrankCopula(
    HG, AG, gam_weiH, lambdaHome, gam_weiA, lambdaAway, theta,
    "conv_dePril", 1, TRUE, conv_extrap = TRUE)


weights <- c(0.01355306, 0.01355306, 0.01355306, 0.01355306, 0.01355306,
             0.01355306, 0.01355306, 0.01355306, 0.01357825, 0.01357825)

weiFrank2 <- dBivariateWeibullCountFrankCopula_loglik(
    HG, AG, gam_weiH, lambdaHome, gam_weiA, lambdaAway, theta,
    "conv_dePril", 1, TRUE, conv_extrap = TRUE, weights = weights)

weiFrank3 <- dBivariateWeibullCountFrankCopula_loglik(
    HG, AG, gam_weiH, lambdaHome, gam_weiA, lambdaAway, theta,
    "series_acc", 1, TRUE, weights = weights)

cbind(weiFrank0, weiFrank1, weiFrank2, weiFrank3)
## rdname dRenewalFrankCopula_user
}

