% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renewal_methods.R
\name{predict.renewal}
\alias{predict.renewal}
\title{Predict method for renewal objects}
\usage{
\method{predict}{renewal}(object, newdata = NULL, type = c("response",
  "prob"), se.fit = FALSE, terms = NULL, na.action = na.pass, time = 1,
  ...)
}
\arguments{
\item{object}{Object of class inheriting from \code{"lm"}}

\item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}

\item{type}{type of prediction.  If equal to \code{"response"}, give the mean
probability associated with the individual covariates. If \code{"prob"},
give the probability of the observed count.}

\item{se.fit}{A switch indicating if standard errors are required.}

\item{terms}{If \code{type = "terms"}, which terms (default is all
    terms), a \code{\link{character}} vector.}

\item{na.action}{function determining what should be done with missing
    values in \code{newdata}.  The default is to predict \code{NA}.}

\item{time}{TODO}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Compute predictions from renewal objects.
}
\examples{
fn <- system.file("extdata", "McShane_Wei_results_boot.RDS", package = "Countr")
object <- readRDS(fn)
data <- object$data
## old data
predOld.response <- predict(object, type = "response", se.fit = TRUE)
predOld.prob <- predict(object, type = "prob", se.fit = TRUE)

## newData (extracted from old Data)
newData <- head(data)
predNew.response <- predict(object, newdata = newData,
                            type = "response", se.fit = TRUE)
predNew.prob <- predict(object, newdata = newData,
                        type = "prob", se.fit = TRUE)

cbind(head(predOld.response$values),
           head(predOld.response$se$scale),
           head(predOld.response$se$shape),
           predNew.response$values,
           predNew.response$se$scale,
           predNew.response$se$shape)

cbind(head(predOld.prob$values),
      head(predOld.prob$se$scale),
      head(predOld.prob$se$shape),
      predNew.prob$values,
      predNew.prob$se$scale,
      predNew.prob$se$shape)
}

