% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convCount_loglik.R
\name{dCount_conv_loglik_bi}
\alias{dCount_conv_loglik_bi}
\alias{dCount_conv_loglik_user}
\title{Log-likelihood of a count probability computed by convolution (bi)}
\usage{
dCount_conv_loglik_bi(
  x,
  distPars,
  dist = c("weibull", "gamma", "gengamma", "burr"),
  method = c("dePril", "direct", "naive"),
  nsteps = 100,
  time = 1,
  extrap = TRUE,
  na.rm = TRUE,
  weights = NULL
)

dCount_conv_loglik_user(
  x,
  distPars,
  extrapolPars,
  survR,
  method = c("dePril", "direct", "naive"),
  nsteps = 100,
  time = 1,
  extrap = TRUE,
  na.rm = TRUE,
  weights = NULL
)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars}{list of the same length as x with each slot being itself a
named list containing the distribution parameters corresponding to
\code{x[i]}.}

\item{dist}{character name of the built-in distribution, see details.}

\item{method}{character, convolution method to be used; choices are
\code{"dePril"} (section 3.2), \code{"direct"} (section 2) or
\code{"naive"} (section 3.1).}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{na.rm}{logical, if TRUE, \code{NA}s (produced by taking the log of
very small probabilities) will be replaced by the smallest allowed
probability; default is \code{TRUE}.}

\item{weights}{numeric, vector of weights to apply. If \code{NULL}, a vector
of ones.}

\item{extrapolPars}{list of same length as x where each slot is a vector of
length 2 (the extrapolation values to be used) corresponding to
\code{x[i]}.}

\item{survR}{a user defined survival function; should have the signature
\code{function(t, distPars)} where \code{t} is a real number (>0) where
the survival function is evaluated and \code{distPars} is a list of
distribution parameters. It should return a double value.}
}
\value{
numeric, the log-likelihood of the count process
}
\description{
Compute the log-likelihood of a count model using  convolution
methods to compute the probabilities.
\code{dCount_conv_loglik_bi} is for the builtin distributions.
\code{dCount_conv_loglik_user} is for user defined survival functions.
}
\examples{
x <- 0:10
lambda <- 2.56
distPars <- list(scale = lambda, shape = 1)
distParsList <- lapply(seq(along = x), function(ind) distPars)
extrapolParsList <- lapply(seq(along = x), function(ind) c(2, 1))
## user pwei
pwei_user <- function(tt, distP) {
    alpha <- exp(-log(distP[["scale"]]) / distP[["shape"]])
    pweibull(q = tt, scale = alpha, shape = distP[["shape"]],
             lower.tail = FALSE)
}

## log-likehood allProbs Poisson
dCount_conv_loglik_bi(x, distParsList,
                      "weibull", "direct", nsteps = 400)

dCount_conv_loglik_user(x, distParsList, extrapolParsList,
                        pwei_user, "direct", nsteps = 400)

## log-likehood naive Poisson
dCount_conv_loglik_bi(x, distParsList,
                      "weibull", "naive", nsteps = 400)

dCount_conv_loglik_user(x, distParsList, extrapolParsList,
                        pwei_user, "naive", nsteps = 400)

## log-likehood dePril Poisson
dCount_conv_loglik_bi(x, distParsList,
                      "weibull", "dePril", nsteps = 400)

dCount_conv_loglik_user(x, distParsList, extrapolParsList,
                        pwei_user, "dePril", nsteps = 400)
## see dCount_conv_loglik_bi()
}
