% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{samplecovs}
\alias{samplecovs}
\title{Generate Sample Covariances of 2 groups}
\usage{
samplecovs(ncopy, size)
}
\arguments{
\item{ncopy}{the total number of sample covariances to be generated.}

\item{size}{dimension \eqn{p}.}
}
\value{
a \eqn{(p\times p\times ncopy)} array of strictly positive definite sample covariances.
}
\description{
For visualization purpose, \code{samplecovs} generates a 3d array
of stacked sample covariances where - in 3rd dimension, the first half
are sample covariances of samples generated independently from
normal distribution with identity covariance, where the latter half
consists of samples covariances from dense random population covariance.
}
\examples{
## generate total of 20 samples covariances of size 5-by-5.
samples <- samplecovs(20,5)


}
