% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphlb.ftest.R
\name{coxphlb.ftest}
\alias{coxphlb.ftest}
\title{Test the Functional Form of Covariates in Cox Model with Right-Censored Length-Biased Data}
\usage{
coxphlb.ftest(fit, data, spec.p = 1, n.sim = 1000, z0 = NULL,
seed.n = round(runif(1,1,1e09)), digits = 3L)
}
\arguments{
\item{fit}{The result of fitting a Cox model, using the \code{coxphlb} function.}

\item{data}{A data frame containing the variables in the model.}

\item{spec.p}{An integer specifying which covariate to be tested. Default is 1. If set to 1, the first column of the covariate matrix is tested.}

\item{n.sim}{The number of resampling. Default is 1000.}

\item{z0}{A vector of grid points to use for the specified covariate. The default is a vector of 100 equally distributed numeric values within the range of the specified covariate.}

\item{seed.n}{An integer specifying seed number.}

\item{digits}{An integer controlling the number of digits to print.}
}
\value{
A list containing the following components:
\item{p.value}{A p-value.}
\item{}{The list is returned as an object of the \code{coxphlb.ftest} class. Objects of this class have methods for the function \code{print}. The object also contains the following: \code{n.sim}; \code{z0}; \code{stat.mat.z}, the test statistic; \code{sim.mat.z}, samples from the null distribution; \code{varnames}, the variable that is tested; \code{result}, the table output.}
}
\description{
Tests the functional form of covariates assumed for a Cox model fit (coxphlb).
}
\details{
The functional form of a continuous covariate is checked by constructing test statistics based on asymptotically mean-zero processes. The asymptotic distribution of the test statistics is approximated via resampling. This function computes the p-value by comparing the test statistics with n.sim number of resamples. If the p-value is small (e.g., <0.05), it is likely that the assumption is violated. The test should be done per variable for continuous covariates.
}
\examples{
\dontrun{
# Fit a Cox model
fit.ee <- coxphlb(Surv(a, y, delta) ~ x1 + x2, data = ExampleData1,
                 method = "EE")

# Check the Functional Form of the Cox Model
ftest <- coxphlb.ftest(fit.ee, data = ExampleData1, spec.p = 2,
                      seed.n = 1234)
print(ftest)			# display the results
}
}
\references{
Lee, C.H., Ning, J., and Shen, Y. Model diagnostics for proportional hazards model with length-biased data. \emph{Lifetime Data Analysis} 25(1), 79-96.
}
\seealso{
\code{\link{coxphlb}}, \code{\link{coxphlb.phtest}}, \code{\link{coxphlb.ftest.plot}}
}
