% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_LP.multipleObservations}
\alias{plot_LP.multipleObservations}
\title{plot_LP.multipleObservations}
\usage{
plot_LP.multipleObservations(
  model,
  new_observations,
  error.bar = FALSE,
  onlySig = TRUE,
  alpha = 0.05,
  zero.rm = TRUE,
  auto.limits = TRUE,
  top = NULL
)
}
\arguments{
\item{model}{Coxmos model.}

\item{new_observations}{Numeric matrix or data.frame. New explanatory variables (raw data). Qualitative
variables must be transform into binary variables.}

\item{error.bar}{Logical. Show error bar (default: FALSE).}

\item{onlySig}{Logical. Compute plot using only significant components (default: TRUE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{zero.rm}{Logical. Remove variables equal to 0 (default: TRUE).}

\item{auto.limits}{Logical. If "auto.limits" = TRUE, limits are detected automatically (default: TRUE).}

\item{top}{Numeric. Show "top" first variables. If top = NULL, all variables are shown (default: NULL).}
}
\value{
A ggplot object visualizing the linear predictors for multiple patients based on the
provided Coxmos model.
}
\description{
Visualizes the linear predictors for multiple patients based on a given Coxmos model.
}
\details{
The function \code{plot_LP.multipleObservations} is designed to visualize the linear predictors for multiple
patients based on the provided Coxmos model. The function takes into account various parameters to
customize the visualization, such as the significance level, error bars, and the number of top
variables to display.

The function works by first checking the class of the provided model. Depending on the model type,
it delegates the plotting task to one of the three methods: classical models, PLS models, or
multi-block PLS models. Each of these methods is tailored to handle specific model types and
produce the desired plots.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
splsicox.model <- splsicox(X_train, Y_train, n.comp = 2, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
plot_LP.multipleObservations(model = splsicox.model, new_observations = X_test[1:5,])
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
