% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_LP.multipleObservations.list}
\alias{plot_LP.multipleObservations.list}
\title{plot_LP.multipleObservations.list}
\usage{
plot_LP.multipleObservations.list(
  lst_models,
  new_observations,
  error.bar = FALSE,
  onlySig = TRUE,
  alpha = 0.05,
  zero.rm = TRUE,
  auto.limits = TRUE,
  top = NULL
)
}
\arguments{
\item{lst_models}{List of Coxmos models.}

\item{new_observations}{Numeric matrix or data.frame. New explanatory variables (raw data). Qualitative
variables must be transform into binary variables.}

\item{error.bar}{Logical. Show error bar (default: FALSE).}

\item{onlySig}{Logical. Compute plot using only significant components (default: TRUE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{zero.rm}{Logical. Remove variables equal to 0 (default: TRUE).}

\item{auto.limits}{Logical. If "auto.limits" = TRUE, limits are detected automatically (default: TRUE).}

\item{top}{Numeric. Show "top" first variables. If top = NULL, all variables are shown (default: NULL).}
}
\value{
A list of ggplot objects for each model in the \code{lst_models}. Each plot visualizes
the linear predictor values for multiple patients based on the specified Coxmos model. The plots
can optionally display error bars, consider only significant components, and can be limited to a
specified number of top variables. The visualization aids in understanding the influence of
explanatory variables on the survival prediction for each patient in the context of the provided
models.
}
\description{
Run the function "plot_LP.multipleObservations" for a list of models. More information
in "?plot_LP.multipleObservations".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .4, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:30]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:30]
Y_test <- Y_proteomic[-index_train,]
splsicox.model <- splsicox(X_train, Y_train, n.comp = 1, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
splsdrcox.model <- splsdrcox_penalty(X_train, Y_train, n.comp = 1, penalty = 0.5, x.center = TRUE,
x.scale = TRUE)
lst_models = list("sPLSICOX" = splsicox.model, "sPLSDRCOX" = splsdrcox.model)
plot_LP.multipleObservations.list(lst_models = lst_models, X_test[1:5,])
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
