% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_multiblock_functions.R
\name{getDesign.MB}
\alias{getDesign.MB}
\title{getDesign.MB}
\usage{
getDesign.MB(Xh)
}
\arguments{
\item{Xh}{List of explanatory blocks.}
}
\value{
A design matrix optimized for the X multi-omic data.
}
\description{
Computes a new design matrix for the multi-block data by running individual PLS
between all omics and calculating its correlation.
}
\details{
The \code{getDesign.MB} function follows the suggestion made by the mixOmics group
for computing design matrices for their algorithms. For more information, check
https://mixomicsteam.github.io/mixOmics-Vignette/id_06.html#id_06:diablo-design.
}
\examples{
data("X_multiomic")
X <- X_multiomic
design <- getDesign.MB(X)

}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
