% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.at1p.R
\name{calibrate.at1p}
\alias{calibrate.at1p}
\title{AT1P model calibration to market CDS data}
\usage{
calibrate.at1p(V0, cdsrate, r, t, ...)
}
\arguments{
\item{V0}{firm value at time \code{t = 0}.}

\item{cdsrate}{CDS rates from market.}

\item{r}{a vector of risk-free rate.}

\item{t}{a vector of debt maturity structure.}

\item{...}{additional parameters used in \code{cds} function.}
}
\value{
\code{calibrate.at1p} returns an object of class \code{data.frame} with calculated parameters of
the \code{at1p} model and the error occurred in the minimization procedure.
}
\description{
Compares CDS rates quoted on the market with theoric CDS rates calculeted by the function
\code{cds} and looks for the parameters to be used into \code{at1p}
for returning the default intensities corresponding to real market CDS rates performing the
minimization of the objective function.
}
\details{
Inside \code{calibrate.at1p}, the function \code{objfn} takes the input a
vector of parameters and returns the mean error occurred estimating CDS rates with
\code{cds} function. The inputs used in \code{cds} are the default intensities calculated by
the \code{at1p} function with the calibrated parameters. In particular the error is
calculated as:
\deqn{\frac{1}{n}\sum_{i=1}^n (c^{ds}-c^{ds}_{mkt})^2.} This quantity is a function of
the default intensities and it is the objective function to be minimized in order to take
optimal solutions for intensities.
}
\examples{
calibrate.at1p(V0 = 1, cdsrate = cdsdata$Par.spread, r = cdsdata$ED.Zero.Curve,
t = cdsdata$Maturity)

}
\references{
Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes
}
