% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_records.R
\name{map_records_tariff2}
\alias{map_records_tariff2}
\title{Map VA records to Tariff 2.}
\usage{
map_records_tariff2(records, csv_outfile = "")
}
\arguments{
\item{records}{A dataframe, obtained from reading an ODKBriefcase
export of records collected with the WHO questionnaire.}

\item{csv_outfile}{Path to a file to write transformed data to.
Defaults to empty string, in which case no file is written.}
}
\value{
A dataframe, with the VA records mapped to the variables required
  by Tariff 2.
}
\description{
\code{map_records} transform data collected with the WHO VA instrument
  for coding with the Tariff 2 algorithm.
}
\examples{
\dontrun{
records <- read.csv('who_va_output.csv')
output_data <- map_records_tariff2(records)
}

}
\references{
James, S. L., Flaxman, A. D., Murray, C. J., & Population Health Metrics Research Consortium. (2011). \emph{Performance of the Tariff Method: validation of a simple additive algorithm for analysis of verbal autopsies.} \emph{Population Health Metrics, 9(1), 1-16.}
}

