% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL_plot.R
\name{KL_plot}
\alias{KL_plot}
\title{Kullback-Leibler divergence plot}
\usage{
KL_plot(
  monitoring,
  n_0 = 10,
  n_stop = 1000,
  title = "Kullback-Liebler divergence trace"
)
}
\arguments{
\item{monitoring}{\code{list} of monitoring estimates from \code{CytOpt()} output.}

\item{n_0}{first iteration to plot. Default is 10.}

\item{n_stop}{last iteration to plot. Default is 1000.}

\item{title}{plot title. Default is \code{"Kullback-Liebler divergence trace"}.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
A plotting function for displaying Kullback-Liebler (KL) divergence across 
iterations of the optimization algorithm(s).
}
\examples{

if(interactive()){

gold_standard_manual_prop <- c(table(HIPC_Stanford_1369_1A_labels) / 
 length(HIPC_Stanford_1369_1A_labels))
res <- CytOpT(X_s = HIPC_Stanford_1228_1A, X_t = HIPC_Stanford_1369_1A, 
             Lab_source = HIPC_Stanford_1228_1A_labels,
             theta_true = gold_standard_manual_prop,
             eps = 0.0001, lbd = 0.0001, n_iter = 10000, n_stoc=10,
             step_grad = 10, step = 5, power = 0.99, 
             method='both', monitoring = TRUE)
plot(res)

}
}
