% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\docType{methods}
\name{statistics}
\alias{statistics}
\alias{statistics.event_counts}
\alias{statistics.event_counts,UserSession-method}
\alias{statistics.general}
\alias{statistics.general,UserSession-method}
\title{Statistic Endpoints}
\usage{
\S4method{statistics.event_counts}{UserSession}(UserSession, experiment_id,
  gate_version = -1, experiment_version, compensation_id, fcs_files,
  populations = c(), output = "default",
  timeout = UserSession@long_timeout)

\S4method{statistics.general}{UserSession}(UserSession, experiment_id,
  gate_version = -1, experiment_version, compensation_id, fcs_files, channels,
  populations = c(), output = "default",
  timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{gate_version}{integer representing an experiment gate version, an integer of -1 corresponds to the state of \link{gates} and \link{populations} in the gating interface. Faster performance can be achieved by using the maximum gate version from the experiment \href{https://support.cytobank.org/hc/en-us/articles/205399487-The-Apply-and-Apply-and-Return-buttons-and-gate-versioning}{(learn more about gate versions)}. Maximum gate version can be seen as the \strong{gateVersion} attribute returned from a call to the \link[=experiments]{Show Experiment Details} endpoint \strong{[optional]}}

\item{experiment_version}{integer representing an experiment version, must be set to the current version of the experiment, which can be seen as the \strong{version} attribute returned from a call to the \link[=experiments]{Show Experiment Details} endpoint}

\item{compensation_id}{integer representing a \link[=compensations]{compensation} ID (use -2 for file-internal compensation, -1 for uncompensated)}

\item{fcs_files}{vector/list of integers representing a list of \link[=fcs_files]{FCS file} IDs}

\item{populations}{vector/list of integers representing a list of population IDs to calculate statistics for. This is the \strong{gateSetId} attribute of a \link[=populations]{population} object. Another term for a population is a "gate set". If not specified, all population statistics will be fetched \strong{[optional]}}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- statistics.event_counts: \code{("default" [default], "dataframe")}}\cr
\emph{- statistics.general: \code{("default", "dataframe_col", "dataframe_row")}}\cr
\emph{- \code{dataframe}: converts the output to a dataframe for the event count statistics}\cr
\emph{- \code{dataframe_col}: for statistics data on multiple channels, proliferate channel statistics as columns}\cr
\emph{- \code{dataframe_row}: for statistics data on multiple channels, proliferate channel statistics as rows}}

\item{timeout}{integer representing the request timeout time in seconds}

\item{channels}{vector/list of integers representing a list of channel IDs}
}
\description{
Interact with statistic endpoints. Gather data about event counts and general channel statistics. Create dataframes of statistics to help with visualization and downstream analysis.
}
\details{
\code{statistics.event_counts} Get event count statistics from an experiment. In the absence of channel information, only event count data are returned. If only event count data are needed, this approach can be faster than retrieving all statistics by avoiding unnecessary computation.\cr
\emph{- Optional output parameter, specify one of the following: \code{("full" [default], "dataframe")}}\cr
\emph{- \code{dataframe}: converts the output to a dataframe for the event count statistics}\cr

\code{statistics.general} Get a batch of common statistics for specific channels on populations from an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("full" [default], "dataframe_col", "dataframe_row")}}\cr
\emph{- \code{dataframe_col}: for statistics data on multiple channels, proliferate channel statistics as columns}\cr
\emph{- \code{dataframe_row}: for statistics data on multiple channels, proliferate channel statistics as rows}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{statistics.event_counts(cyto_session, 22, experiment_version=22, compensation_id=-2,
  fcs_files=c(12, 13, 14), channels=c(53, 54, 55), populations=c(32, 33, 34))
}
\donttest{# Full list with all fields present
statistics.general(cyto_session, 22, experiment_version=22, compensation_id=-2,
  fcs_files=c(12, 13, 14), channels=c(53, 54, 55), populations=c(32, 33, 34))

# Statistics list transformed into a dataframe, proliferating channel statistics by column
statistics.general(cyto_session, 22, experiment_version=22, compensation_id=-2,
  fcs_files=c(12, 13, 14), channels=c(53, 54, 55), populations=c(32, 33), output="dataframe_col")

# Statistics list transformed into a dataframe, proliferating channel statistics by row
statistics.general(cyto_session, 22, experiment_version=22, compensation_id=-2,
  fcs_files=c(12, 13, 14), channels=c(53, 54, 55), populations=c(32, 33), output="dataframe_row")

# Statistics list transformed into a dataframe, using helper functions (names_to_ids)
# Get FCS files that match 'pbmc' in their filename
fcs_files <- fcs_files.list(cyto_session, 22)
fcs_files <- fcs_files[,c("id", "filename")]
fcs_files <- unlist(fcs_files$id[grep("pbmc", fcs_files$filename)])

# Get channels that match 'pp' or 'pStat' as their longName
channels <- panels.list(cyto_session, 22)$`Panel 1`$channels
channels <- channels[,c("normalizedShortNameId", "shortName", "longName")]
channels <- channels$normalizedShortNameId[grep("pp.*|pStat.*", channels$longName)]

# Get populations that match 'CD' as their population name
populations <- populations.list(cyto_session, 22)
populations <- populations[,c("gateSetId", "name")]
populations <- populations$id[grep("CD.*", populations$name)]

statistics.general(cyto_session, 22, experiment_version=61, compensation_id=-2,
  fcs_files=fcs_files, channels=channels, populations=populations, output="dataframe_row")
}
}

