% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserSession-class.R
\docType{class}
\name{UserSession-class}
\alias{UserSession-class}
\title{S4 Cytobank UserSession Class}
\value{
A Cytobank UserSession object
}
\description{
A Cytobank UserSession object that holds pertinent user information, used to make calls to various Cytobank endpoints.
This class should never be called explicitly. If a user would like to create a new Cytobank UserSession object, utilize the \link{authenticate} function.
}
\section{Slots}{

\describe{
\item{\code{auth_token}}{character representing Cytobank user's authentication token (expires in 8 hours)}

\item{\code{long_timeout}}{numeric representing long request timeout times}

\item{\code{short_timeout}}{numeric representing short request timeout times}

\item{\code{site}}{character representing Cytobank user's site}
}}
\examples{
cytobank_user <- new("UserSession", auth_token="my_auth_token", site="premium")
}

