% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterfiles.R
\name{filterfiles}
\alias{filterfiles}
\title{Filters a list of fcs files by search terms}
\usage{
filterfiles(files, string)
}
\arguments{
\item{files}{- List of fcs file IDs with FCS file name as names for list}

\item{string}{- List of one or more strings of interest as a list to filter samples}
}
\value{
Returns a list of  file IDs matching with names matching string(s)
}
\description{
Filters a list of fcs files by search terms
}
\examples{
\donttest{
#Example starting with obtaining data from Cytobank
library(CytobankAPI)
exptno<-4
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
files<-getfcsfiles(exptno,cyto_session)
string<-c("patient","IL-1b")
filterfiles(file,string)}

#Simple example when list of file names is already available
files<-1:4
names(files)<-c("Pt1 unst.fcs","Pt2 stim.fcs","Ctrl1 unst.fcs","Ctrl2 stim.fcs")
#Filtering file list to contain only unstimulated files
filterfiles(files,"unstimulated")
#Filtering file list to contain only patient files
filterfiles(files,"Pt")
#Filtering file list to contain both unstimulated and patient files
filterfiles(files,c("Pt","unst"))
}
