% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getrawsignals.R
\name{getrawsignals}
\alias{getrawsignals}
\title{Computes the untransformed medians for cellular markers in populations of interest}
\usage{
getrawsignals(cyto_session, markersofinterest, popsofinterest, exptID,
  markerorder, stimterms, ptterms)
}
\arguments{
\item{cyto_session}{- API authentication token for session}

\item{markersofinterest}{- List of strings of markers of interest, corresponding to names in Cytobank}

\item{popsofinterest}{- List of strings of populations of interest to calculate statistics}

\item{exptID}{- Integer representing an experiment ID on Cytobank account}

\item{markerorder}{- A list of stings corresponding to the desired marker order}

\item{stimterms}{- A list of desired stimulation conditions to analyze in matrix}

\item{ptterms}{- A list of desired sample conditions to analyze in matrix}
}
\value{
- Returns matrix of untransformed medians for cellular markers in populations of interest
}
\description{
Computes the untransformed medians for cellular markers in populations of interest
}
\examples{
\donttest{
library(CytobankAPI)
cyto_session <- authenticate(site="premium", username="myusername", password="mypassword")
markersofinterest<-c("CD3","CD56")
popsofinterest<-c("CD4 T cells","NK cells")
exptID=4
markerorder<-c("CD4 T cells CD56","NK cells CD56","CD4 T cells CD3","NK cells CD3")
stimterms<-c("Unstim","IL-15")
ptterm<-c("Pt","Ctrl")
getrawsignals(cyto_session,markersofinterest,popsofinterest,exptID,markerorder,stimterms,
ptterms)}
}
