% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{initialize,D2C.Data-method}
\alias{initialize,D2C.Data-method}
\title{create a data structure that store a network and a sample of the distribution}
\usage{
\S4method{initialize}{D2C.Data}(.Object, network, data,
  lin = stop("lin must be specified"), ratioMissingNode = 0.05,
  nConnected = 4, nDisonnected = 6,
  functionDescriptor = stop("functionDescriptor must be specified"))
}
\arguments{
\item{.Object}{a D2C.data}

\item{network}{: a network generated by D2C.network}

\item{data}{: matrix generated with method compute of D2C.network}

\item{lin}{: TRUE or FALSE}

\item{ratioMissingNode}{: numeric a ratio of missing edge}

\item{nConnected}{:  number of connected edge in the training or test sample}

\item{nDisonnected}{:  number of disconnected in the training or test sample}

\item{functionDescriptor}{: a descriptor function used in the D2C algorithm}
}
\value{
N*nNodes matrix
}
\description{
create a data structure that store a network and a sample of the distribution
}
\examples{
require(D2C)
require(gRbase)
require(RBGL)
H=function() function(x) return(x)
sdn=0.5
sigma=function(x) return(rnorm(n = 1,sd = sdn))
DAG = new("D2C.network",network=random_dag(1:50,maxpar = 5,wgt=0.8),H=H,sdn=sdn,sigma=sigma)
X = compute(DAG,N=200)
DATA = new("D2C.Data",network=DAG@network,data=X,ratioMissingNode=0.05,
           lin=TRUE,nConnected = 4,nDisonnected = 6,functionDescriptor=descriptor)
}
\references{
Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
}

