% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{initialize,D2C.network-method}
\alias{initialize,D2C.network-method}
\title{create a D2C.network}
\usage{
\S4method{initialize}{D2C.network}(.Object, network, sdn = 0.5,
  sigma = function(x) return(rnorm(n = 1, sd = sdn)), H = function()
  function(x) return(x))
}
\arguments{
\item{.Object}{a D2C.network}

\item{network}{a DAG network}

\item{sdn}{the standart deviation of the noise}

\item{sigma}{a noise function}

\item{H}{the dependency function}
}
\value{
N*nNodes matrix
}
\description{
\code{new("D2C.network",network=random_dag(1:50,maxpar = 5,wgt=0.8),H=H,sdn=sdn,sigma=sigma)} returns D2C.network object
}
\examples{
require(D2C)
require(gRbase)
require(RBGL)
H=function() function(x) return(x)
sdn=0.5
sigma=function(x) return(rnorm(n = 1,sd = sdn))
DAG = new("D2C.network",network=random_dag(1:50,maxpar = 5,wgt=0.8),H=H,sdn=sdn,sigma=sigma)
X = compute(DAG,N=200)
#H is a function which return a function.
}
\references{
Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
}

