% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.ProbBasedMethodology.R
\name{ProbBasedMethodology}
\alias{ProbBasedMethodology}
\title{Methodology to obtain the combination of the probability of different
metrics.}
\description{
Calculates the mean of the probabilities of the different
metrics.
}
\seealso{
\code{\link{Methodology}}
}
\keyword{math}
\keyword{methods}
\keyword{models}
\section{Super class}{
\code{\link[D2MCS:Methodology]{D2MCS::Methodology}} -> \code{ProbBasedMethodology}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ProbBasedMethodology$new()}}
\item \href{#method-compute}{\code{ProbBasedMethodology$compute()}}
\item \href{#method-clone}{\code{ProbBasedMethodology$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="D2MCS" data-topic="Methodology" data-id="getRequiredMetrics">}\href{../../D2MCS/html/Methodology.html#method-getRequiredMetrics}{\code{D2MCS::Methodology$getRequiredMetrics()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbBasedMethodology$new(required.metrics = c("MCC", "PPV"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{required.metrics}}{A \link{character} vector of length
greater than 2 with the name of the required metrics.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute"></a>}}
\if{latex}{\out{\hypertarget{method-compute}{}}}
\subsection{Method \code{compute()}}{
Function to compute the probability of the final prediction
based on different metrics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbBasedMethodology$compute(
  raw.pred,
  prob.pred,
  positive.class,
  negative.class
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw.pred}}{A \link{character} list of length greater than 2 with the
class value of the predictions made by the metrics.}

\item{\code{prob.pred}}{A \link{numeric} list of length greater than 2 with the
probability of the predictions made by the metrics.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}

\item{\code{negative.class}}{A \link{character} with the value of the
negative class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} value indicating the probability of the instance
is predicted as positive class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProbBasedMethodology$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
