% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskFiles.R
\name{scanReport}
\alias{scanReport}
\title{Read data into vector or list using function \code{\link{scan}}.}
\usage{
scanReport(
  task,
  type,
  ext = "txt",
  subdir = NULL,
  dirCreate = TRUE,
  what = "",
  ...
)
}
\arguments{
\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Filename type. If the type is an array, the cocatenation of the elements is used with separator"-". Filenames have the form [task name]_[type].[ext]}

\item{ext}{Filename extension.}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{what}{the \link[base]{type} of \code{what} gives the type of data to
    be read.  (Here \sQuote{type} is used in the sense of
    \code{\link[base]{typeof}}.)  The supported types are \code{logical},
    \code{integer}, \code{numeric}, \code{complex}, \code{character},
    \code{raw} and \code{\link[base]{list}}.  If \code{what} is a list, it is
    assumed that the lines of the data file are records each containing
    \code{length(what)} items (\sQuote{fields}) and the list components
    should have elements which are one of the first six (\link[base]{atomic})
    types listed or \code{NULL}, see section \sQuote{Details} below.}

\item{...}{
  Arguments passed on to \code{\link[base:scan]{base::scan}}
  \describe{
    \item{\code{file}}{the name of a file to read data values from.  If the
    specified file is \code{""}, then input is taken from the keyboard
    (or whatever \code{\link[base]{stdin}()} reads if input is redirected or
    \R is embedded).
    (In this case input can be terminated by a blank line or an EOF
    signal, \samp{Ctrl-D} on Unix and \samp{Ctrl-Z} on Windows.)

    Otherwise, the file name is interpreted \emph{relative} to the
    current working directory (given by \code{\link[base]{getwd}()}),
    unless it specifies an \emph{absolute} path.
    Tilde-expansion is performed where supported.
    When running \R from a script, \code{file = "stdin"} can be used to
    refer to the process's \code{stdin} file stream.

    This can be a compressed file (see \code{\link[base]{file}}).

    Alternatively, \code{file} can be a \code{\link[base]{connection}},
    which will be opened if necessary, and if so closed at the end of
    the function call.  Whatever mode the connection is opened in,
    any of LF, CRLF or CR will be accepted as the EOL marker for a line
    and so will match \code{sep = "\n"}.

    \code{file} can also be a complete URL.  (For the supported URL
    schemes, see the \sQuote{URLs} section of the help for
    \code{\link[base]{url}}.)

    To read a data file not in the current encoding (for example a
    Latin-1 file in a UTF-8 locale or conversely) use a
    \code{\link[base]{file}} connection setting its \code{encoding} argument
    (or \code{scan}'s \code{fileEncoding} argument).
  }
    \item{\code{nmax}}{the maximum number of data values to be read, or if
    \code{what} is a list, the maximum number of records to be read.  If
    omitted or not positive or an invalid value for an integer
    (and \code{nlines} is not set to a positive value), \code{scan} will
    read to the end of \code{file}.}
    \item{\code{n}}{integer: the maximum number of data values to be read, defaulting to
    no limit.  Invalid values will be ignored.}
    \item{\code{sep}}{by default, scan expects to read \sQuote{white-space}
    delimited input fields.  Alternatively, \code{sep} can be used to
    specify a character which delimits fields.  A field is always
    delimited by an end-of-line marker unless it is quoted.

    If specified this should be the empty character string (the default)
    or \code{NULL} or a character string containing just one single-byte
    character.
  }
    \item{\code{quote}}{the set of quoting characters as a single character
    string or \code{NULL}.  In a multibyte locale the quoting characters
    must be ASCII (single-byte).}
    \item{\code{dec}}{decimal point character.  This should be a character string
    containing just one single-byte character.  (\code{NULL} and a
    zero-length character vector are also accepted, and taken as the
    default.)}
    \item{\code{skip}}{the number of  lines of the input file to skip before
    beginning to read data values.}
    \item{\code{nlines}}{if positive, the maximum number of lines of data to be read.}
    \item{\code{na.strings}}{character vector.  Elements of this vector are to be
    interpreted as missing (\code{\link[base]{NA}}) values.  Blank fields are
    also considered to be missing values in logical, integer, numeric
    and complex fields.  Note that the test happens \emph{after} 
    white space is stripped from the input, so \code{na.strings} values 
    may need their own white space stripped in advance.}
    \item{\code{flush}}{logical: if \code{TRUE}, \code{scan} will flush to the
    end of the line after reading the last of the fields requested.
    This allows putting comments after the last field, but precludes
    putting more that one record on a line.}
    \item{\code{fill}}{logical: if \code{TRUE}, \code{scan} will implicitly add
    empty fields to any lines with fewer fields than implied by
    \code{what}.}
    \item{\code{strip.white}}{vector of logical value(s) corresponding to items
    in the \code{what} argument.  It is used only when \code{sep} has
    been specified, and allows the stripping of leading and trailing
    \sQuote{white space} from \code{character} fields (\code{numeric} fields
    are always stripped).  Note: white space inside quoted strings is
    not stripped.

    If \code{strip.white} is of length 1, it applies to all fields;
    otherwise, if \code{strip.white[i]} is \code{TRUE} \emph{and} the
    \code{i}-th field is of mode character (because \code{what[i]} is)
    then the leading and trailing unquoted white space from field \code{i} is
    stripped.
  }
    \item{\code{quiet}}{logical: if \code{FALSE} (default), scan() will print a
    line, saying how many items have been read.}
    \item{\code{blank.lines.skip}}{logical: if \code{TRUE} blank lines in the
    input are ignored, except when counting \code{skip} and \code{nlines}.}
    \item{\code{multi.line}}{logical.  Only used if \code{what} is a list.  If
    \code{FALSE}, all of a record must appear on one line (but more than
    one record can appear on a single line).  Note that using \code{fill = TRUE}
    implies that a record will be terminated at the end of a line.}
    \item{\code{comment.char}}{character: a character vector of length one
    containing a single character or an empty string.  Use \code{""} to
    turn off the interpretation of comments altogether (the default).}
    \item{\code{allowEscapes}}{logical.  Should C-style escapes such as
    \samp{\\n} be processed (the default) or read verbatim?   Note that if
    not within quotes these could be interpreted as a delimiter (but not
    as a comment character).

    The escapes which are interpreted are the control characters
    \samp{\\a, \\b, \\f, \\n, \\r, \\t, \\v} and octal and
    hexadecimal representations like \samp{\\040} and \samp{\\0x2A}.  Any
    other escaped character is treated as itself, including backslash.
    Note that Unicode escapes (starting \samp{\\u} or \samp{\\U}: see
    \link[base]{Quotes}) are never processed.
  }
    \item{\code{fileEncoding}}{character string: if non-empty declares the
    encoding used on a file (not a connection nor the keyboard) so the
    character data can be re-encoded.  See the \sQuote{Encoding} section
    of the help for \code{\link[base]{file}}, and the \sQuote{R Data
      Import/Export Manual}.
  }
    \item{\code{encoding}}{encoding to be assumed for input strings.  If the
    value is \code{"latin1"} or \code{"UTF-8"} it is used to mark
    character strings as known to be in Latin-1 or UTF-8: it is not used
    to re-encode the input (see \code{fileEncoding}).
    See also \sQuote{Details}.
  }
    \item{\code{text}}{character string: if \code{file} is not supplied and this is,
    then data are read from the value of \code{text} via a text connection.
  }
    \item{\code{skipNul}}{logical: should nuls be skipped when reading character
    fields?}
  }}
}
\value{
the data read, or \code{NULL} if the file does not exist.
}
\description{
Read data into vector or list using function \code{\link{scan}}.
}
