% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAFOT_function.R
\name{DataGenerating}
\alias{DataGenerating}
\title{Generate random data on tree}
\usage{
DataGenerating(mP, mQ, alphaP, alphaQ, n)
}
\arguments{
\item{mP}{an integer. The number of samples in the first group}

\item{mQ}{an integer. The number of samples in the second group}

\item{alphaP}{A vector of numeric. the parameter in Dirichlet distribution for the first group}

\item{alphaQ}{A vector of numeric. the parameter in Dirichlet distribution for the second group}

\item{n}{an integer. The number of reads drawn for each sample.}
}
\value{
\code{DataGenerating} returns a list of two matrix of the raw data generated from Dirichlet-multinomial distribution.
}
\description{
\code{DataGenerating} generate data from Dirichlet-multinomial distribution.
}
\details{
This function is used to generate m distributions from Dirichlet, and draw samples from multinomial distribution.
}
\examples{
alphaP=rep(100,1)
alphaQ=rep(100,2)
DataGenerating(100,100,alphaP,alphaQ,10000)

}
\seealso{
\code{\link{DAFOT}}
}
\author{
Shulei Wang
}
