\name{KPgLastOccurrences}
\alias{KPgLastOccurrences}
\docType{data}
\title{Last occurrences for K/Pg boundary and potential influence of Deccan Volcanism}
\description{
Contains last occurrences generated by the extinction at the K/Pg boundary and influence of Deccan volcanism. Relative influence of volcanism ranges from 0\% (none), 10 \% (weak), 20\% (intermediate), 30 \% (strong) to 40\% (very strong).
Location of deccan volcanism is based on the extinction interval from Tobin (2017), fig 5, transformed into time assuming a constant deposition rate.
The last occurrences were generated based on the procedure by Hohmann (2018) and a rate of fossil occurrences of 40 fossils per ma.
}
\usage{data(SeymourIslandBins)}
\format{A list with entries, each named after the age model described in Hohmann (in preparation). Each of these age models is divided into
An list containing two vecotrs 'agemodelage' and 'agemodelheight' corresponding to the time of deposition of a given stratigraphic height
A description of the paraameters used to generate the age models
}

\examples{
data(KPgLastOccurrences)
KPgLastOccurrences$Intermediate.Deccan$parameters
plot(KPgLastOccurrences$Intermediate.Deccan$age,
  KPgLastOccurrences$Intermediate.Deccan$val,type='l',
  xlim=range(KPgLastOccurrences$Intermediate.Deccan$age))
}
\source{

Hohmann, Niklas. 2018. Quantifying the Effects of Changing Deposition Rates and Hiatii on the Stratigraphic Distribution of Fossils. <doi:10.13140/RG.2.2.23372.51841>.

}
\references{
Hohmann, Niklas. (2018). Reversing Time Averaging and Reconstructing Extinction Rates with Approaches from Image Processing. DOI 10.1101/408864. 

Tobin, Thomas S. "Recognition of a likely two phased extinction at the K-Pg boundary in Antarctica." Scientific reports 7.1 (2017): 1-11.
}
\keyword{dataset}
\keyword{Seymour}
\keyword{K/Pg}
\keyword{Stratigraphy}