% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_format_IW_sampled_stt.R
\name{DAISIE_format_IW_sampled_stt}
\alias{DAISIE_format_IW_sampled_stt}
\title{Formats island-wide simulation output into standard
DAISIE list output}
\usage{
DAISIE_format_IW_sampled_stt(
  island_replicates,
  total_time,
  M,
  sample_freq,
  verbose
)
}
\arguments{
\item{island_replicates}{List output from
\code{\link{DAISIE_sim_core_cr}()},
\code{\link{DAISIE_sim_core_time_dep}()},
\code{\link{DAISIE_sim_core_cr_shift}()} or
\code{\link{DAISIE_sim_min_type2}()} functions. Minimally, this must be a
list that has as many elements as replicates. Each element must be a list
with the elements \code{island_age}, \code{not_present} and \code{stt_all}.
\code{stt_all} must be a data frame with the column names \code{Time},
\code{nI}, \code{nA}, \code{nC} and \code{present}.}

\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{M}{Numeric defining the size of mainland pool, i.e. the number of
species that can potentially colonize the island.}

\item{sample_freq}{Numeric specifing the number of units times should be
divided by for plotting purposes. Larger values will lead to plots with
higher resolution, but will also run slower.}

\item{verbose}{In simulation and dataprep functions a logical,
\code{Default = TRUE} gives intermediate output should be printed.
For ML functions a numeric determining if intermediate output should be
printed, \code{Default = 0} does not print, \code{verbose = 1} prints
intermediate output of the parameters and loglikelihood, \code{verbose = 2}
means also intermediate progress during loglikelihood computation is shown.}
}
\value{
List with IW DAISIE simulation output
}
\description{
Formats island-wide simulation output into standard
DAISIE list output
}
\keyword{internal}
