% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_dropout.R
\name{loss_cross_entropy}
\alias{loss_cross_entropy}
\alias{loss_sum_of_squares}
\alias{loss_root_mean_square}
\title{Preimplemented Loss Functions}
\usage{
loss_cross_entropy(observed, predicted, p_min = 1e-04)
}
\arguments{
\item{observed}{observed scores or labels, these are supplied as explainer specific `y`}

\item{predicted}{predicted scores, either vector of matrix, these are returned from the model specific `predict_function()``}

\item{p_min}{for cross entropy, minimal value for probability to make sure that `log` will not explode}
}
\value{
numeric - value of the loss function
}
\description{
Preimplemented Loss Functions
}
\examples{
 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status~., data = HR, ntree = 100)
loss_cross_entropy(HR$status, yhat(HR_rf_model))
 }
}
