% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable_response.R
\name{plot.variable_response_explainer}
\alias{plot.variable_response_explainer}
\title{Plot Marginal Model Explanations (Single Variable Responses)}
\usage{
\method{plot}{variable_response_explainer}(x, ..., use_facets = FALSE)
}
\arguments{
\item{x}{a single variable exlainer produced with the \code{\link{single_variable}} function}

\item{...}{other explainers that shall be plotted together}

\item{use_facets}{logical. If TRUE then separate models are on different facets}
}
\value{
a ggplot2 object
}
\description{
Function \code{\link{plot.variable_response_explainer}}
plots marginal responses for one or more explainers.
}
\examples{
HR$evaluation <- factor(HR$evaluation)

HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
expl_glm <- variable_response(explainer_glm, "age", "pdp")
plot(expl_glm)

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status == "fired" ~., data = HR)
explainer_rf  <- explain(HR_rf_model, data = HR)
expl_rf  <- variable_response(explainer_rf, variable = "age",
                       type = "pdp")
plot(expl_rf)
plot(expl_rf, expl_glm)

# Example for factor variable (with factorMerger)
expl_rf  <- variable_response(explainer_rf, variable =  "evaluation", type = "factor")
plot(expl_rf)

expl_glm  <- variable_response(explainer_glm, variable =  "evaluation", type = "factor")
plot(expl_glm)

# both models
plot(expl_rf, expl_glm)
 }

}
