% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_diagnostics.R
\name{model_diagnostics}
\alias{model_diagnostics}
\title{Dataset Level Model Diagnostics}
\usage{
model_diagnostics(explainer, variables = NULL, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain} function}

\item{variables}{character - name of variables to be explained. Default \code{NULL} stands for all variables}

\item{...}{other parameters}
}
\value{
An object of the class \code{model_diagnostics}.
It's a data frame with residuals and selected variables.
}
\description{
This function performs model diagnostic of residuals.
Residuals are calculated and ploted against predictions, true y values or selected variables.
Find information how to use this function here: \url{https://pbiecek.github.io/ema/residualDiagnostic.html}.
}
\examples{
apartments_lm_model <- lm(m2.price ~ ., data = apartments)
explainer_lm <- explain(apartments_lm_model,
                         data = apartments,
                         y = apartments$m2.price)
diag_lm <- model_diagnostics(explainer_lm)
diag_lm
plot(diag_lm)
\dontrun{
library("ranger")
apartments_ranger_model <- ranger(m2.price ~ ., data = apartments)
explainer_ranger <- explain(apartments_ranger_model,
                         data = apartments,
                         y = apartments$m2.price)
diag_ranger <- model_diagnostics(explainer_ranger)
diag_ranger
plot(diag_ranger)
plot(diag_ranger, diag_lm)
plot(diag_ranger, diag_lm, variable = "y")
plot(diag_ranger, diag_lm, variable = "construction.year")
plot(diag_ranger, variable = "y", yvariable = "y_hat")
plot(diag_ranger, variable = "y", yvariable = "abs_residuals")
plot(diag_ranger, variable = "ids")
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
