% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_yhat.R
\name{yhat}
\alias{yhat}
\alias{yhat.lm}
\alias{yhat.randomForest}
\alias{yhat.svm}
\alias{yhat.gbm}
\alias{yhat.glm}
\alias{yhat.cv.glmnet}
\alias{yhat.glmnet}
\alias{yhat.ranger}
\alias{yhat.model_fit}
\alias{yhat.train}
\alias{yhat.lrm}
\alias{yhat.rpart}
\alias{yhat.default}
\title{Wrap Various Predict Functions}
\usage{
yhat(X.model, newdata, ...)

\method{yhat}{lm}(X.model, newdata, ...)

\method{yhat}{randomForest}(X.model, newdata, ...)

\method{yhat}{svm}(X.model, newdata, ...)

\method{yhat}{gbm}(X.model, newdata, ...)

\method{yhat}{glm}(X.model, newdata, ...)

\method{yhat}{cv.glmnet}(X.model, newdata, ...)

\method{yhat}{glmnet}(X.model, newdata, ...)

\method{yhat}{ranger}(X.model, newdata, ...)

\method{yhat}{model_fit}(X.model, newdata, ...)

\method{yhat}{train}(X.model, newdata, ...)

\method{yhat}{lrm}(X.model, newdata, ...)

\method{yhat}{rpart}(X.model, newdata, ...)

\method{yhat}{default}(X.model, newdata, ...)
}
\arguments{
\item{X.model}{object - a model to be explained}

\item{newdata}{data.frame or matrix - observations for prediction}

\item{...}{other parameters that will be passed to the predict function}
}
\value{
An numeric matrix of predictions
}
\description{
This function is a wrapper over various predict functions for different models and differnt model structures.
The wrapper returns a single numeric score for each new observation.
To do this it uses different extraction techniques for models from different classes,
like for classification random forest is forces the output to be probabilities
not classes itself.
}
\details{
Currently supported packages are:
\itemize{
\item class \code{cv.glmnet} and \code{glmnet} - models created with \pkg{glmnet} package,
\item class \code{glm} - generalized linear models created with \link[stats]{glm},
\item class \code{model_fit} - models created with \pkg{parsnip} package,
\item class \code{lm} - linear models created with \link[stats]{lm},
\item class \code{ranger} - models created with \pkg{ranger} package,
\item class \code{randomForest} - random forest models created with \pkg{randomForest} package,
\item class \code{svm} - support vector machines models created with the \pkg{e1071} package,
\item class \code{train} - models created with \pkg{caret} package,
\item class \code{gbm} - models created with \pkg{gbm} package,
\item class \code{lrm} - models created with \pkg{rms} package,
\item class \code{rpart} - models created with \pkg{rpart} package.
}
}
