% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_info.R
\name{model_info}
\alias{model_info}
\alias{model_info.lm}
\alias{model_info.randomForest}
\alias{model_info.svm}
\alias{model_info.glm}
\alias{model_info.lrm}
\alias{model_info.glmnet}
\alias{model_info.cv.glmnet}
\alias{model_info.ranger}
\alias{model_info.gbm}
\alias{model_info.model_fit}
\alias{model_info.train}
\alias{model_info.rpart}
\alias{model_info.default}
\title{Exract info from model}
\usage{
model_info(model, is_multiclass = FALSE, ...)

\method{model_info}{lm}(model, is_multiclass = FALSE, ...)

\method{model_info}{randomForest}(model, is_multiclass = FALSE, ...)

\method{model_info}{svm}(model, is_multiclass = FALSE, ...)

\method{model_info}{glm}(model, is_multiclass = FALSE, ...)

\method{model_info}{lrm}(model, is_multiclass = FALSE, ...)

\method{model_info}{glmnet}(model, is_multiclass = FALSE, ...)

\method{model_info}{cv.glmnet}(model, is_multiclass = FALSE, ...)

\method{model_info}{ranger}(model, is_multiclass = FALSE, ...)

\method{model_info}{gbm}(model, is_multiclass = FALSE, ...)

\method{model_info}{model_fit}(model, is_multiclass = FALSE, ...)

\method{model_info}{train}(model, is_multiclass = FALSE, ...)

\method{model_info}{rpart}(model, is_multiclass = FALSE, ...)

\method{model_info}{default}(model, is_multiclass = FALSE, ...)
}
\arguments{
\item{model}{- model object}

\item{is_multiclass}{- if TRUE and task is classification, then multitask classification is set. Else is omitted. If \code{model_info}
was executed withing \code{explain} function. DALEX will recognize subtype on it's own.}

\item{...}{- another arguments

Currently supported packages are:
\itemize{
\item class \code{cv.glmnet} and \code{glmnet} - models created with \pkg{glmnet} package
\item class \code{glm} - generalized linear models
\item class \code{lrm} - models created with \pkg{rms} package,
\item class \code{model_fit} - models created with \pkg{parsnip} package
\item class \code{lm} - linear models created with \code{stats::lm}
\item class \code{ranger} - models created with \pkg{ranger} package
\item class \code{randomForest} - random forest models created with \pkg{randomForest} package
\item class \code{svm} - support vector machines models created with the \pkg{e1071} package
\item class \code{train} - models created with \pkg{caret} package
\item class \code{gbm} - models created with \pkg{gbm} package
}}
}
\value{
A named list of class \code{model_info}
}
\description{
This generic function let user extract base information about model. The function returns a named list of class \code{model_info} that
contain about package of model, version and task type. For wrappers like \code{mlr} or \code{caret} both, package and wrapper inforamtion
are stored
}
\examples{
aps_lm_model4 <- lm(m2.price ~., data = apartments)
model_info(aps_lm_model4)

\donttest{
library("ranger")
model_regr_rf <- ranger::ranger(status~., data = HR, num.trees = 50, probability = TRUE)
model_info(model_regr_rf, is_multiclass = TRUE)
}

}
