% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{pgumbel}
\alias{pgumbel}
\title{PDF of the Gumbel Distribution}
\usage{
pgumbel(q, location = 0, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{Vector of quantiles}

\item{location}{The location parameter, \eqn{mu}.  This is not the mean of the Gumbel distribution.}

\item{scale}{The scale parameter \eqn{sigma}.}

\item{lower.tail}{Logical, whether lower, if \code{TRUE} or upper, if \code{FALSE}, tail probabilities should be returned.}

\item{log.p}{Logical, if \code{TRUE} probabilities are given in their log.}
}
\value{
A vector of probabilities
}
\description{
Returns the PDF of the Gumbel distribution.
}
\details{
This code and the details of the help file were taken from the \code{VGAM} package.

The Gumbel distribution is a special case of the \emph{generalized extreme value} 
(GEV) distribution where the shape parameter \eqn{\xi}{xi} = 0. The latter has 3 parameters, so 
the Gumbel distribution has two.  The Gumbel distribution function is 
\deqn{G(y) = \exp \left( - \exp \left[ - \frac{y-\mu}{\sigma} \right]\right) }
where \eqn{-\infty<y<\infty}, \eqn{-\infty<\mu<\infty}and \eqn{\sigma>0}.
Its mean is
\deqn{\mu - \sigma * \gamma}
and its variance is
\deqn{\sigma^2 * \pi^2 / 6}
where \eqn{\gamma}{gamma} is Euler's constant (which can be obtained as \code{-digamma(1)}).
}
\author{
Thomas Yee
}
