% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_getting_started.R
\name{test_getting_started}
\alias{test_getting_started}
\title{Getting started with testing}
\usage{
test_getting_started(skip = NULL, ctx = get_default_context())
}
\arguments{
\item{skip}{\code{[character()]}\cr A vector of regular expressions to match
against test names; skip test if matching any.}

\item{ctx}{\code{[DBItest_context]}\cr A test context as created by
\code{\link{make_context}}.}
}
\description{
Tests very basic features of a DBI driver package, to support testing
and test-first development right from the start.
}
\details{
This function defines the following tests:
\describe{
\item{\code{has_context}}{
\code{make_context()} must be called before calling any of the
\code{test_} functions in this package}
\item{\code{package_dependencies}}{
Can relate the driver to an installed (or devtools-loaded) package;
package depends (!) on "DBI" and imports "methods"}. This test requires
the \code{devtools} package and will be skipped if it is not installed.
\item{\code{package_name}}{
Optional: Package name starts with R.
}
}
}
\seealso{
Other tests: \code{\link{test_compliance}},
  \code{\link{test_connection}}, \code{\link{test_driver}},
  \code{\link{test_meta}}, \code{\link{test_result}},
  \code{\link{test_sql}}
}

