% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{set.options}
\alias{set.options}
\title{Set Options for the DCS procedure}
\usage{
set.options(
  type = "LP",
  kerns = c("MW_220", "MW_220"),
  drv = c(0, 0),
  var_est = "iid",
  ...
)
}
\arguments{
\item{type}{either local polynomial regression (\code{"LP"}, the default) or 
kernel regression (\code{"KR"}).}

\item{kerns}{a character vector of length 2 containing the identifier for the
kernels to be used in kernel regression. Weighting functions in local
polynomial regression are computed according to the identifier. Default value
is \code{MW_220}, the Mueller-Wang kernel of order \eqn{(2, 2, 0)}.}

\item{drv}{A non-negative vector of length 2, containing the derivative
orders to be estimated from the given data. The default is \code{c(0, 0)}. For
LP-regression, polynomial order is selected as \eqn{(\nu_1 + 1, \nu_2 + 1)}.}

\item{var_est}{the method of estimating the variance coefficient \eqn{c_f}. 
Currently available are \code{var_est = "iid"} (the default), where an iid. 
error structure is modeled and \code{var_est = "qarma"}, where a spatial
ARMA model is applied. Use \code{"qarma_gpac"} for automated order 
selection.}

\item{...}{Additional arguments passed to \code{set.options()}. This includes
\code{IPI_options}, a list containing further options used by the iterative
plug-in algorithm.}
}
\value{
An object of class \code{"dcs_options"}.
}
\description{
Set Options for the DCS procedure
}
\section{Details}{

This function is used to set the options for bandwidth selection in the 
\code{dcs} function. Detailed information can be found in the vignette.
}

\examples{
# See vignette("DCSmooth") for examples and explanation

set.options()

myOpt <- set.options(type = "KR", var_est = "qarma")
y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs(y, dcs_options = myOpt)
}
\seealso{
\code{\link{dcs}}
}
