% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{set.options}
\alias{set.options}
\title{Set Options for the DCS procedure}
\usage{
set.options(
  type = "LP",
  kerns = c("MW_220", "MW_220"),
  drv = c(0, 0),
  var_model = "iid",
  ...
)
}
\arguments{
\item{type}{either local polynomial regression (\code{"LP"}, the default) or 
kernel regression (\code{"KR"}).}

\item{kerns}{a character vector of length 2 containing the identifier for the
kernels to be used in kernel regression. Weighting functions in local
polynomial regression are computed according to the identifier. Default value
is \code{MW_220}, the Mueller-Wang kernel of order \eqn{(2, 2, 0)}. If only
a single value is provided, it is used as kernel in both directions.}

\item{drv}{A non-negative vector of length 2, containing the derivative
orders to be estimated from the given data. The default is \code{c(0, 0)}. For
LP-regression, polynomial order is selected as \eqn{(\nu_1 + 1, \nu_2 + 1)}.
If only a single value is provided, it is used as derivative in both 
directions.}

\item{var_model}{the method of estimating the variance coefficient \eqn{c_f}. 
Currently available are \code{var_model = c("iid", "sarma_HR", "sarma_sep",
"sarma_RSS", "sfarima_RSS")}. Replacing the argument \code{var_model}. For
code using \code{var_est}, the argument is converted to \code{var_model}.}

\item{...}{Additional arguments passed to \code{set.options()}. This includes
\code{IPI_options}, a list containing further options used by the iterative
plug-in algorithm. For convenience, any of the options usually included in 
the list \code{IPI_options} can be passed as argument directly to 
\code{set.options} and will be converted into the \code{IPI_options} list.
Further arguments accepted are \code{model_order} controlling the order of
the variance model, if either an SARMA or SFARIMA model is used. This 
argument is either a list of the form \code{list(ar = c(1, 1), ma = c(1, 1))}
or specifies an order selection criterion from \code{c("aic", "bic", "gpac")}.
If an order selection criterion is used, the argument \code{order_max} 
controls the maximum order to be tested.}
}
\value{
An object of class \code{"dcs_options"}.
}
\description{
Set Options for the DCS procedure
}
\section{Details}{

This function is used to set the options for bandwidth selection in the 
\code{dcs} function.
Detailed information can be found in the vignette.
}

\examples{
# See vignette("DCSmooth") for examples and explanation

set.options()

myOpt <- set.options(type = "KR", var_model = "iid")
y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs(y, dcs_options = myOpt)
}
\seealso{
\code{\link{dcs}}
}
