% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w0.net.R
\name{w0.net}
\alias{w0.net}
\title{Estimates the initial parameter vector of the neural net model}
\usage{
w0.net(
  x,
  y,
  m = 2,
  h = 2,
  rangx = 1/max(abs(x)),
  w0maxit = 100,
  seed.t = TRUE,
  seed = 56666459
)
}
\arguments{
\item{x}{a \code{matrix} or a \code{data.frame} denoting the explanatory variables.}

\item{y}{a \code{vector}, a \code{matrix} or a \code{data.frame} denoting the response variable.}

\item{m}{a non-negative integer denoting the embedding dimension (Default 2).}

\item{h}{a non-negative integer denoting the number of neurones (or nodes) in the single hidden layer (Default 2).}

\item{rangx}{a non-negative integer denoting the range of the explanatory variables (Default 1/max(abs(x)).}

\item{w0maxit}{a non-negative integer denoting the maximum iterations to estimate the initial parameter vector of the neural net models (Default 100).}

\item{seed.t}{a logical value denoting if the user wants to fix the seed \code{TRUE} or not \code{FALSE} (Default TRUE).}

\item{seed}{a non-negative integer denoting the value of the seed selected if \code{seed.t = TRUE} (Default 56666459).}
}
\value{
The optimal initial parameter vector of the neural net model considering the argument set selected by the user.
}
\description{
This function estimates the initial parameter vector of the neural net model.
}
\note{
The process of adjustment to a neural network often suffers from being trapped in local optima and different initialization strategies should be taken into account. For this reason the function \code{w0.net} have been implemented. This function estimates previously the initial parameter vector of the neural net model being able to set the maximum number of iterations that the user wants to obtain setting \code{w0maxit}. In addition, by default the neural network estimation is initialized with a fixed seed denoted by \code{seed.t=TRUE} with a value equal to \code{seed=56666459}. The R user can let the seed be fixed either randomly by \code{seed.t=FALSE} or even fix other value of the seed to be able to replicate the results obtained.
}
\references{
Ripley, B.D. 1996 Pattern Recognition and Neural Networks. Cambridge.

Venables, W.N., Ripley, B.D. 2002 Modern Applied Statistics with S. Fourth edition. Springer.

Hornik, K., Stinchcombe, M., White, H. 1989 Multilayer feedforward networks are universal approximators. Neural Networks 2(5):359-366.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
